/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.outconn;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rcs.conndata.PassthruInfo;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConnectivityConstants;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.HashMap;

public class TestPassThruSystemBean
extends PanelBean
implements OutboundConnectivityConstants {
    private static final String TRACE_MASKT = "XRCSTPBT";
    private static final String TRACE_MASKF = "XRCSTPBF";
    private static final String TRACE_MASKD = "XRCSTPBD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-TPThBean");
    private PassthruInfo passthruInfo;
    private boolean testInProgress = false;
    private boolean testStopping = false;
    private Object statusLock;
    private String m_sIpAddress;
    private String m_sComment;
    private String m_sStatus;

    public TestPassThruSystemBean() {
        Trace.trace(TRACE_MASKT, "<> TestPassThruSystemBean()");
    }

    public void setIpAddress(String s) throws IllegalUserDataException {
        this.m_sIpAddress = s;
    }

    public String getIpAddress() {
        return this.m_sIpAddress;
    }

    public void setComment(String s) throws IllegalUserDataException {
        this.m_sComment = s;
    }

    public String getComment() {
        return this.m_sComment;
    }

    public void setStatus(String s) throws IllegalUserDataException {
        this.m_sStatus = s;
    }

    public String getStatus() {
        return this.m_sStatus;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> verifyChanges()");
        Trace.trace(TRACE_MASKT, "<- verifyChanges()");
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "-> load()");
        this.m_sIpAddress = "";
        this.m_sComment = "";
        this.m_sStatus = "";
        Trace.trace(TRACE_MASKT, "<- load()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "-> save()");
        Trace.trace(TRACE_MASKT, "<- save()");
    }

    public void setPassthruInfo(PassthruInfo info) {
        Trace.trace(TRACE_MASKT, "<> setPassthruInfo(" + info + ")");
        this.passthruInfo = info;
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> prepare()");
        this.statusLock = new Object();
        this.updateDataBeanInfo(true);
        this.updateUTMElements();
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void panelAction(TaskActionEvent event) {
        block11: {
            Trace.trace(TRACE_MASKT, "-> panelAction(" + event + ")");
            try {
                String element = event.getElementName();
                if (element.endsWith("StartButton")) {
                    if (!this.testInProgress) {
                        this.testInProgress = true;
                        this.testStopping = false;
                        this.m_sStatus = "";
                        this.updateUTMElements();
                        PanelTaskletRequest request = new PanelTaskletRequest();
                        request.setSource("TestPassThruSystemrBean");
                        request.setData("Source", "TestPassThruSystemPanel");
                        request.setData("Command", "Start");
                        request.setData("PassThruInfo", this.passthruInfo);
                        this.postTaskletRequest(request);
                    }
                    break block11;
                }
                if (element.endsWith("StopButton")) {
                    if (!this.testStopping) {
                        this.testStopping = true;
                        LocalizableText msg = new LocalizableText("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnMsgs", "TEST_STOP");
                        Object object = this.statusLock;
                        synchronized (object) {
                            this.m_sStatus = this.m_sStatus.concat("\n" + msg.toString());
                            this.updateUTMElements();
                        }
                    }
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setSource("TestPassThruSystemrBean");
                    request.setData("Source", "TestPassThruSystemPanel");
                    request.setData("Command", "Stop");
                    this.postTaskletRequest(request);
                    break block11;
                }
                if (element.endsWith("CancelButton")) {
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setSource("TestPassThruSystemrBean");
                    request.setData("Source", "TestPassThruSystemPanel");
                    request.setData("Command", "Cancel");
                    this.postTaskletRequest(request);
                } else {
                    Trace.trace(TRACE_MASKF, "Unknown element");
                }
            }
            catch (RuntimeException rte) {
                new FrameworkLog(classLogInfo, 1941, rte).log();
                this.dispose();
            }
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object newData) {
        block10: {
            Trace.trace(TRACE_MASKT, "-> update");
            try {
                HashMap data = (HashMap)newData;
                String command = (String)data.get("Command");
                if (command == null) {
                    command = "";
                }
                Trace.trace(TRACE_MASKF, "command=" + command);
                if (command.equals("")) {
                    Trace.trace(TRACE_MASKF, "Unspecified command");
                    break block10;
                }
                if (command.equals("UpdateStatus")) {
                    LocalizableText statusInfo = (LocalizableText)data.get("StatusInfo");
                    if (statusInfo == null) break block10;
                    Object object = this.statusLock;
                    synchronized (object) {
                        this.m_sStatus = this.m_sStatus.equals("") ? statusInfo.toString() : this.m_sStatus.concat("\n" + statusInfo.toString());
                        this.updateUTMElements();
                        break block10;
                    }
                }
                if (command.equals("TestComplete")) {
                    this.testInProgress = false;
                    this.updateUTMElements();
                } else {
                    Trace.trace(TRACE_MASKF, "Unknown command");
                }
            }
            catch (RuntimeException rte) {
                new FrameworkLog(classLogInfo, 1941, rte).log();
                this.dispose();
            }
        }
        Trace.trace(TRACE_MASKT, "<- update");
    }

    private void updateDataBeanInfo(boolean initialUpdate) {
        Trace.trace(TRACE_MASKT, "-> updateDataBeanInfo(" + initialUpdate + ")");
        if (initialUpdate) {
            this.m_sIpAddress = this.passthruInfo.getIpAddress();
            this.m_sComment = this.passthruInfo.getDescription();
        }
        Trace.trace(TRACE_MASKT, "<- updateDataBeanInfo()");
    }

    private void updateUTMElements() {
        Trace.trace(TRACE_MASKT, "<- updateUTMElements()");
        if (this.userTaskManager != null) {
            String prefix = this.getMountPrefix();
            if (this.testInProgress) {
                this.userTaskManager.setEnabled(prefix + "StartButton", false);
                this.userTaskManager.setEnabled(prefix + "StopButton", true);
            } else {
                this.userTaskManager.setEnabled(prefix + "StartButton", true);
                this.userTaskManager.setEnabled(prefix + "StopButton", false);
            }
            this.userTaskManager.refreshAllElements();
        }
        Trace.trace(TRACE_MASKT, "<- updateUTMElements()");
    }
}

